#include "function.h"


/************************************************************************/
/* Name: readImage
/* Function: Read the Image database.
/* Input: fDir: the directory of the file.
/*        cNum: the index of the character which need to be read.
/*		  cNum_num: the size of index. 
/* Output: dat: the handwriting content of the corresponding characters.
/* Return:
/* Explain:
/* Amendant record			
/* Date          Edition       Modifier      Summary
/* 10/12/2009    V1.0          Suqin Ao      Establish 
/************************************************************************/
BYTE **readImage(char *fDir, int *cNum, int cNum_num)
{
	/******open file, read the number of characters in the file.***********/
	FILE *file_id;
	if (!(file_id = fopen(fDir, "rb"))) 
	{
		printf("cannot open the image file!");
		exit(1);
	}
	DWORD iNum;
	BYTE iHeight, iWidth;
	WORD iSamples;

	fread(&iNum, sizeof(DWORD), 1, file_id);
	fread(&iHeight, sizeof(BYTE), 1, file_id);
	fread(&iWidth, sizeof(BYTE), 1, file_id);
	iSamples = iHeight * iWidth;

	int maxIndex = myMax(cNum, cNum_num);
	if(maxIndex > (int)iNum)
	{
		printf("Error, the indexs are exceed the number of characters.");
		exit(1);
	}

	BYTE **dat;
	BYTE *data;

	dat = (BYTE **)malloc(sizeof(BYTE *) * cNum_num);


	int i, j;

	for(i = 0; i < cNum_num; i ++)
	{
		
		
		data = (BYTE *)malloc(sizeof(BYTE) * iSamples);
		if(i > 0)
		{
			for(j = cNum[i-1]; j < cNum[i] - 1; j ++)
				fseek(file_id, iSamples, SEEK_CUR);
		}

		fread(data, sizeof(BYTE), iSamples, file_id);
		dat[i] = data;
	}
	return dat;
}
